Attribute VB_Name = "E1432"
'
'  Visual Basic Function prototypes for E1432 DLL
'  " $Id: e1432.bas,v 1.44 1999/03/12 21:25:56 daven Exp $ "
'  from e1432.h,v 1.4 1994/10/07
'
' Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved.
' This Visual Basic file declares the functions provided by E1432.DLL

' As far as I know, this file is used only for the 16-bit Windows
' version of the production front panel.  It contains only what is
' needed to make that work, and probably shouldn't be modified unless
' it is necessary.  If you want to use VB with an E1432, you should
' probably use hpe1432.bas instead.

'  Software characteristics

' VXI ID registers
Global Const E1432_MAN_ID = &HFFF                     '  HP ID
Global Const E1432_MODEL_CODE = &H201                 '  E1432 ID
Global Const E1432_MODEL_CODE_NOT_BOOTED = &H200       ' E1432 ID
Global Const E1432_MODEL_CODE_E1432 = &H201            ' E1432 ID
Global Const E1432_MODEL_CODE_E1433 = &H202            ' E1433 ID
Global Const E1432_MODEL_CODE_E1434 = &H203            ' E1434 ID

Global Const E1432_MODULES = 255                      '  max number of E1432s
Global Const E1432_CHANS = 20                         '  channels per module
Global Const E1432_INPUT_CHANS = 16                   '  max input chan/module
Global Const E1432_TACH_CHANS = 2
Global Const E1432_SCAS = 5                           '  SCAs per module
Global Const E1432_MOD_MAX = 15                       ' Modules per system. scpi maximum
Global Const E1432_ORDER_BLOCKSIZE_MAX = 8192                      '  !!! scpi maximum
Global Const E1432_SICL_NAME_MAX = 20                 '  length of interface name

'  Hardware characteristics
Global Const E1432_ANALOG_DELAY = (0.000011925) ' sec
Global Const E1432_AC_SETTLING_TIME = 15#       ' sec
Global Const E1432_AC_RANGING_TIME = 2#         ' sec
Global Const E1432_OVHD = 2.189784              ' dB
Global Const E1432_TACH_WRAP_COUNT = 4294967296#

'  SCA IDs
Global Const E1432_SCA_ID_NONE = &H1F
Global Const E1432_SCA_ID_TACH = 4
Global Const E1432_SCA_ID_VIBRATO = 10
Global Const E1432_SCA_ID_SONATA_A = 12
Global Const E1432_SCA_ID_SONATA_B = 13
Global Const E1432_SCA_ID_SONATA = E1432_SCA_ID_SONATA_A
Global Const E1432_SCA_ID_CLARINET = 6
Global Const E1432_SCA_ID_CLARION = 7

'  Break-out box IDs
Global Const E1432_BOB_ID_NONE = &H0
Global Const E1432_BOB_ID_CHARGE_PROTO = &HFE
Global Const E1432_BOB_ID_MIKE_PROTO = &HFD
Global Const E1432_BOB_ID_CHARGE = &HFC
Global Const E1432_BOB_ID_MIKE = &HFB
Global Const E1432_BOB_ID_CHARGE2 = &HFA
Global Const E1432_BOB_ID_MIKE2 = &HF9

'  Channel software characteristics
Global Const E1432_CHAN_TYPE_INPUT = 0
Global Const E1432_CHAN_TYPE_SOURCE = 1
Global Const E1432_CHAN_TYPE_TACH = 2
Global Const E1432_CHAN_TYPE_OTHER = 3
Global Const E1432_CHAN_TYPES = 4

'  e1432_install flags
Global Const E1432_INSTALL_FAST = &H1&
Global Const E1432_INSTALL_FASTER = &H2&
Global Const E1432_INSTALL_FASTEST = &H4&
Global Const E1432_INSTALL_FROM_MEM = &H100&
Global Const E1432_INSTALL_DEOMPRESS = &H200&
Global Const E1432_INSTALL_SYSCALLS = &H8000000


' VXI Address offsets of registers from module base address
Global Const E1432_ID_REG = &H0
Global Const E1432_LOGICAL_ADDRESS_REG = &H0
Global Const E1432_DEVICE_TYPE_REG = &H2
Global Const E1432_STATUS_REG = &H4
Global Const E1432_CONTROL_REG = &H4
Global Const E1432_OFFSET_REG = &H6
Global Const E1432_PORT_CTL_REG = &H8
Global Const E1432_PAGE_MAP_REG = &HA
Global Const E1432_IRQ_CONFIG_REG = &HC
Global Const E1432_IRQ_STATUS_REG = &HE
Global Const E1432_IRQ_STATUS2_REG = &H10
Global Const E1432_MEAS_STATE_REG = &H14
Global Const E1432_FIFO_DATA_REG = &H18
Global Const E1432_FIFO_COUNT_REG = &H1E
Global Const E1432_SRC_STATUS_REG = &H8F0

'  E1432_SRC_STATUS_REG
Global Const E1432_SRC_STATUS_UNDERRUN4 = &H1
Global Const E1432_SRC_STATUS_UNDERRUN2 = &H2
Global Const E1432_SRC_STATUS_UNDERRUN0 = &H4
Global Const E1432_SRC_STATUS_OVERREAD4 = &H8
Global Const E1432_SRC_STATUS_OVERREAD2 = &H10
Global Const E1432_SRC_STATUS_OVERREAD0 = &H20
Global Const E1432_SRC_STATUS_SHUTDOWN4 = &H40
Global Const E1432_SRC_STATUS_SHUTDOWN2 = &H80
Global Const E1432_SRC_STATUS_SHUTDOWN0 = &H100
Global Const E1432_SRC_STATUS_OVERLOAD4 = &H200
Global Const E1432_SRC_STATUS_OVERLOAD2 = &H400
Global Const E1432_SRC_STATUS_OVERLOAD0 = &H800

'  Actions

'  e1432_reset_lbus
Global Const E1432_RESET_LBUS_ON = 306
Global Const E1432_RESET_LBUS_OFF = 307

'  e1432_test_lbus
Global Const E1432_LBUS_TEST_LEFT = 335
Global Const E1432_LBUS_TEST_CENTER = 336
Global Const E1432_LBUS_TEST_RIGHT = 337

'  e1432_set_blocksize
Global Const E1432_BLOCKSIZE_MIN = 1                  '  1 sample
Global Const E1432_BLOCKSIZE_DEF = 1024

'  e1432_set_center_freq
Global Const E1432_CENTER_FREQ_MIN = 0#
Global Const E1432_CENTER_FREQ_MAX = 25600#

'  e1432_set_decimation_bandwidth
Global Const E1432_DECIMATION_MIN = 0
Global Const E1432_DECIMATION_MAX = 16
Global Const E1432_DECIMATION_DEF = 0

'  e1432_set_filter_settling_time
Global Const E1432_FILTER_SETTLING_MIN = 0
Global Const E1432_FILTER_SETTLING_MAX = 255
Global Const E1432_FILTER_SETTLING_DEF = 64


'  e1432_set_overlap
Global Const E1432_OVERLAP_DEF = 0

'  e1432_set_span
Global Const E1432_SPAN_MIN = 0.78               '  Hz
Global Const E1432_SPAN_MAX = 2400000#           '  Hz
Global Const E1432_SPAN_DEF = 20000#

'  e1432_set_trigger_delay
Global Const E1432_TRIG_DELAY_DEF = 0

'  Analog setup parameters

'  e1432_set_anti_alias_analog
Global Const E1432_ANTI_ALIAS_ANALOG_ON = 112
Global Const E1432_ANTI_ALIAS_ANALOG_OFF = 113

'  e1432_set_coupling
Global Const E1432_COUPLING_AC = 100
Global Const E1432_COUPLING_DC = 101
Global Const E1432_COUPLING_AC_BOB_HP = 102
Global Const E1432_COUPLING_DC_BOB_HP = 103


'  e1432_set_input_high
Global Const E1432_INPUT_HIGH_NORMAL = 120
Global Const E1432_INPUT_HIGH_CALIN = 121
Global Const E1432_INPUT_HIGH_GROUNDED = 122
Global Const E1432_INPUT_HIGH_CALOUT = 123
Global Const E1432_INPUT_HIGH_BOB_CALIN = 124

'  e1432_set_input_low
Global Const E1432_INPUT_LOW_GROUNDED = 140
Global Const E1432_INPUT_LOW_FLOATING = 141

'  e1432_set_input_mode
Global Const E1432_INPUT_MODE_VOLT = 130
Global Const E1432_INPUT_MODE_ICP = 131
Global Const E1432_INPUT_MODE_CHARGE = 132
Global Const E1432_INPUT_MODE_MIC = 133
Global Const E1432_INPUT_MODE_MIC_200V = 134

'  e1432_set_source_mode
Global Const E1432_SOURCE_MODE_SINE = 170
Global Const E1432_SOURCE_MODE_BSINE = 171
Global Const E1432_SOURCE_MODE_RAND = 172
Global Const E1432_SOURCE_MODE_BRAND = 173
Global Const E1432_SOURCE_MODE_RANDZ = 174
Global Const E1432_SOURCE_MODE_BRANDZ = 175
Global Const E1432_SOURCE_MODE_ARB = 176
Global Const E1432_SOURCE_MODE_BARB = 177

'  e1432_set_source_output
Global Const E1432_SOURCE_OUTPUT_NORMAL = 700
Global Const E1432_SOURCE_OUTPUT_GROUNDED = 701
Global Const E1432_SOURCE_OUTPUT_OPEN = 702
Global Const E1432_SOURCE_OUTPUT_CAL = 703
Global Const E1432_SOURCE_OUTPUT_MULTI = 704

'  e1432_set_source_cola
Global Const E1432_SOURCE_COLA_OFF = 180
Global Const E1432_SOURCE_COLA_ON = 181

'  e1432_set_source_sum
Global Const E1432_SOURCE_SUM_OFF = 190
Global Const E1432_SOURCE_SUM_ON = 191

'  Timing setup parameters

'  e1432_set_clock_source
Global Const E1432_CLOCK_VXI_DEC_3 = 204
Global Const E1432_CLOCK_SOURCE_EXTERNAL = 206
Global Const E1432_CLOCK_SOURCE_EXTERNALN = 207
Global Const E1432_CLOCK_SOURCE_INTERNAL = 208
Global Const E1432_CLOCK_SOURCE_VXI = 209
Global Const E1432_CLOCK_SOURCE_INT_VXI10 = 210

'  e1432_set_multi_sync
Global Const E1432_MULTI_SYNC_ON = 220
Global Const E1432_MULTI_SYNC_OFF = 221
Global Const E1432_MULTI_SYNC_VXD = 222
Global Const E1432_MULTI_SYNC_VXD_MIN = 223

'  e1432_set_clock_master
Global Const E1432_MASTER_CLOCK_ON = 240
Global Const E1432_MASTER_CLOCK_OFF = 241

'  e1432_set_auto_group_meas
Global Const E1432_AUTO_GROUP_MEAS_ON = 242
Global Const E1432_AUTO_GROUP_MEAS_OFF = 243


'  e1432_set_ttltrg_lines
Global Const E1432_TTLTRG_01 = 250
Global Const E1432_TTLTRG_23 = 251
Global Const E1432_TTLTRG_45 = 252
Global Const E1432_TTLTRG_67 = 253

'  e1432_set_ttltrg_xxx
Global Const E1432_TTLTRG_DISABLE = 260
Global Const E1432_TTLTRG_0 = 261
Global Const E1432_TTLTRG_1 = 262
Global Const E1432_TTLTRG_2 = 263
Global Const E1432_TTLTRG_3 = 264
Global Const E1432_TTLTRG_4 = 265
Global Const E1432_TTLTRG_5 = 266
Global Const E1432_TTLTRG_6 = 267
Global Const E1432_TTLTRG_7 = 268

'  Data I/O setup parameters

'  e1432_set_data_port
Global Const E1432_SEND_PORT_VME = 300
Global Const E1432_SEND_PORT_LBUS = 301

'  e1432_set_lbus_mode
Global Const E1432_LBUS_MODE_GENERATE = 302
Global Const E1432_LBUS_MODE_PIPE = 303
Global Const E1432_LBUS_MODE_INSERT = 304
Global Const E1432_LBUS_MODE_APPEND = 305
Global Const E1432_LBUS_MODE_CONSUME = 306

'  Data format setup parameters

'  e1432_read_float32_data, e1432_read_float64_data
Global Const E1432_TIME_DATA = 345
Global Const E1432_FREQ_DATA = 346
Global Const E1432_RESAMP_DATA = 347
Global Const E1432_ORDER_DATA = 348


'  e1432_set_append_status
Global Const E1432_APPEND_STATUS_OFF = 310
Global Const E1432_APPEND_STATUS_ON = 311

'  e1432_set_data_size
Global Const E1432_DATA_SIZE_NONE = 330
Global Const E1432_DATA_SIZE_16 = 331
Global Const E1432_DATA_SIZE_32 = 332
Global Const E1432_DATA_SIZE_32_SERV = 333
Global Const E1432_DATA_SIZE_FLOAT32 = 334
Global Const E1432_DATA_SIZE_FRACT = 758
Global Const E1432_DATA_SIZE_FLOAT64 = 759

Global Const E1432_DATA_SIZE_32_MASK = &HFFFFFF00

'  e1432_set_data_mode
Global Const E1432_BLOCK_MODE = 340
Global Const E1432_CONTINUOUS_MODE = 341
Global Const E1432_DATA_MODE_OVERLAP_BLOCK = 342
Global Const E1432_DATA_MODE_OVERLAP_FREERUN = 343

'  Triggering setup parameters

'  e1432_set_trigger_slope
Global Const E1432_TRIGGER_SLOPE_POS = 410
Global Const E1432_TRIGGER_SLOPE_NEG = 411

'  e1432_set_trigger_mode
Global Const E1432_TRIGGER_MODE_LEVEL = 414
Global Const E1432_TRIGGER_MODE_BOUND = 415

'  e1432_set_trigger_level
Global Const E1432_TRIGGER_LEVEL_LOWER = 416
Global Const E1432_TRIGGER_LEVEL_UPPER = 417

'  e1432_set_trigger_ext
Global Const E1432_TRIGGER_EXT_OFF = 470
Global Const E1432_TRIGGER_EXT_POS = 471
Global Const E1432_TRIGGER_EXT_NEG = 472
Global Const E1432_TRIGGER_EXT_PREARM_POS = 473
Global Const E1432_TRIGGER_EXT_PREARM_NEG = 474

'  e1432_set_trigger_channel
'  e1432_set_active
Global Const E1432_CHANNEL_ON = 420
Global Const E1432_CHANNEL_OFF = 421
Global Const E1432_CHANNEL_MAYBE = 422
Global Const E1432_CHANNEL_PRE_ARM = 423

'  e1432_set_auto_arm
Global Const E1432_AUTO_ARM_CONTINUOUS = 429
Global Const E1432_MANUAL_ARM = 430
Global Const E1432_AUTO_ARM = 431
Global Const E1432_ARM_RPM_RUNUP = 432
Global Const E1432_ARM_RPM_RUNDOWN = 433
Global Const E1432_ARM_RPM_DELTA = 434
Global Const E1432_ARM_EXTERNAL = 435
Global Const E1432_ARM_TIME = 436
Global Const E1432_ARM_TIME_OR_RPM = 437


'  e1432_set_auto_trigger
Global Const E1432_MANUAL_TRIGGER = 440
Global Const E1432_TACH_EDGE_TRIGGER = 440  'same as manual
Global Const E1432_AUTO_TRIGGER = 441

'  e1432_set_trigger_master
Global Const E1432_TRIGGER_MASTER_OFF = 450
Global Const E1432_TRIGGER_SLAVE = 451
Global Const E1432_TRIGGER_MASTER_ON = 452

' e1432_set_calin parameter values
Global Const E1432_CALIN_OPEN = 510
Global Const E1432_CALIN_GROUND = 511
Global Const E1432_CALIN_DC_HI = 512
Global Const E1432_CALIN_DC_LO = 513
Global Const E1432_CALIN_SUMBUS = 514
Global Const E1432_CALIN_CALOUT = 515
Global Const E1432_CALIN_SUMBUS_TACH = 516

' e1432_set_sumbus parameter values
Global Const E1432_SUMBUS_OFF = 520
Global Const E1432_SUMBUS_CALOUT = 521

'  Decimation filter setup parameters

'  e1432_set_anti_alias_digital
Global Const E1432_ANTI_ALIAS_DIGITAL_ON = 615
Global Const E1432_ANTI_ALIAS_DIGITAL_OFF = 616
Global Const E1432_ANTI_ALIAS_DIGITAL_BES = 617

'  e1432_set_decimation_output
Global Const E1432_ONEPASS = 620
Global Const E1432_MULTIPASS = 621

'  e1432_set_zoom
Global Const E1432_ZOOM_ON = 622
Global Const E1432_ZOOM_OFF = 623

'  e1432_set_ramp
Global Const E1432_RAMP_ON = 625
Global Const E1432_RAMP_OFF = 626

'  e1432_set_decimation_oversample
Global Const E1432_DECIMATION_OVERSAMPLE_OFF = 630
Global Const E1432_DECIMATION_OVERSAMPLE_ON = 631

' e1432_set_enable
Global Const E1432_ENABLE_TYPE_TIME = 270
Global Const E1432_ENABLE_TYPE_FREQ = 271
Global Const E1432_ENABLE_TYPE_RESAMPLE = 272
Global Const E1432_ENABLE_TYPE_ORDER = 273

' e1432_get_group_info
Global Const E1432_GROUP_INFO_NUM_MODULES = 230
Global Const E1432_GROUP_INFO_LIST_MODULES = 231
Global Const E1432_GROUP_INFO_NUM_CHANNELS = 232
Global Const E1432_GROUP_INFO_LIST_CHANNELS = 233
Global Const E1432_GROUP_INFO_NUM_INPUTS = 234
Global Const E1432_GROUP_INFO_LIST_INPUTS = 235
Global Const E1432_GROUP_INFO_NUM_SOURCES = 236
Global Const E1432_GROUP_INFO_LIST_SOURCE = 237
Global Const E1432_GROUP_INFO_NUM_TACHS = 238
Global Const E1432_GROUP_INFO_LIST_TACHS = 239

Global Const E1432_ENABLE_ON = 280
Global Const E1432_ENABLE_OFF = 281

' e1432_set_avg_mode
Global Const E1432_AVG_NONE = 700
Global Const E1432_AVG_RMS = 701
Global Const E1432_AVG_LIN = 702
Global Const E1432_AVG_EXP = 703
Global Const E1432_AVG_PEAK = 704

' e1432_set_window
Global Const E1432_WINDOW_UNIFORM = 710
Global Const E1432_WINDOW_HANNING = 711
Global Const E1432_WINDOW_FLATTOP = 712
Global Const E1432_WINDOW_USER1 = 713
Global Const E1432_WINDOW_USER2 = 714

' e1432_set_sample_mode
Global Const E1432_SAMP_RESAMP = 720
Global Const E1432_SAMP_TIME = 721
Global Const E1432_SAMP_AT_TACH = 722

' e1432_set_calc_data
Global Const E1432_DATA_TIME = 724
Global Const E1432_DATA_FREQ = 725
Global Const E1432_DATA_RESAMP_TIME = 726
Global Const E1432_DATA_ORDER = 727
Global Const E1432_DATA_CORR_FREQ = 728
Global Const E1432_DATA_FIR = 729
Global Const E1432_DATA_USER1 = 730
Global Const E1432_DATA_USER2 = 731
Global Const E1432_DATA_OCTAVE = 730

' /* e1432_set_srcbuffer_init */
Global Const E1432_SRCBUFFER_INIT_EMPTY = 1
Global Const E1432_SRCBUFFER_INIT_RESET = 2
Global Const E1432_SRCBUFFER_INIT_XFER = 3

' /* e1432_set_srcbuffer_mode */
Global Const E1432_SRCBUFFER_CONTINUOUS = 1
Global Const E1432_SRCBUFFER_PERIODIC_AB = 2
Global Const E1432_SRCBUFFER_PERIODIC_A = 4
Global Const E1432_SRCBUFFER_SWITCHEDAUTO = 8
Global Const E1432_SRCBUFFER_SWITCHEDCMD = 16

' /* e1432_set_srcparm_mode */
Global Const E1432_SRCPARM_MODE_DEFR = &H0&
Global Const E1432_SRCPARM_MODE_IMMED = &HC00000

' /* e1432_update_srcparm */
Global Const E1432_SRCPARM_UPDATE_IMMED = &HC00000
Global Const E1432_SRCPARM_UPDATE_XING = &HA00000
Global Const E1432_SRCPARM_UPDATE_TRGIN = &H900000
Global Const E1432_SRCPARM_UPDATE_IMMEDTRGOUT = &HC80000
Global Const E1432_SRCPARM_UPDATE_XINGTRGOUT = &HA80000
Global Const E1432_SRCPARM_UPDATE_TRGINTRGOUT = &H980000

' /* e1432_get_src_arbstates */
Global Const E1432_SRCBUF_RDY = &H0&
Global Const E1432_SRCBUF_AVAIL = &H1&
Global Const E1432_SRCBUF_FULL = &H2&
Global Const E1432_SRCBUF_OUT = &H4&

Global Const E1432_SRC_XFRBUF_WDS_EMPTY = &H0&

' /* e1432_write_srcbuffer_data */
Global Const E1432_SRC_DATA_NUMWORDS_MAX = 4096
Global Const E1432_SRC_DATA_MODE_A = &H1&
Global Const E1432_SRC_DATA_MODE_B = &H2&
Global Const E1432_SRC_DATA_MODE_AB = &H3&
Global Const E1432_SRC_DATA_MODE_WAITA = &H4&
Global Const E1432_SRC_DATA_MODE_WAITB = &H5&
Global Const E1432_SRC_DATA_MODE_WAITAB = &H6&
Global Const E1432_SRC_DATA_MODE_RESETA = &H7&
Global Const E1432_SRC_DATA_MODE_RESETB = &H8&

' e1432_set_weighting
Global Const E1432_WEIGHTING_OFF = 105
Global Const E1432_WEIGHTING_A = 106
Global Const E1432_WEIGHTING_B = 107
Global Const E1432_WEIGHTING_C = 108


' /* Bit position defines in the trailer structure */
Global Const E1432_TRAILER_INFO_NOT_UNDERRANGE = &H1
Global Const E1432_TRAILER_INFO_OVERLOAD = &H2
Global Const E1432_TRAILER_INFO_OVERLOAD_COMM = &H4
Global Const E1432_TRAILER_INFO_TRIGGER = &H8
Global Const E1432_TRAILER_INFO_SETTLED = &H10
Global Const E1432_TRAILER_INFO_STOP = &H20
Global Const E1432_TRAILER_INFO_OT_RAMP_TOO_FAST = &H40
                              


' e1432_zap
Global Const E1432_ZAP_BOOT = 1
Global Const E1432_ZAP_ID_CAL = 2
Global Const E1432_ZAP_CLAR_ID_CAL = 3   ' Clarinet ID/CAL constants
Global Const E1432_ZAP_SRC12_ID_CAL = 4  ' E1434 Ch 1 & 2 Id/cal
Global Const E1432_ZAP_SRC34_ID_CAL = 5   'E1434 Ch 3 & 4 Id/cal
Global Const E1432_ZAP_CLAR_BOOT = 6
Global Const E1432_ZAP_SRC12_BOOT = 7
Global Const E1432_ZAP_SRC34_BOOT = 8
Global Const E1432_ZAP_SUBST_PARM2 = 9

'e1432_zap_parm2_opts
Global Const E1432_PROG_NOP = 0       'do nothing
Global Const E1432_PROG_CLEAR = 1     'clear all entries
Global Const E1432_PROG_DELETE = 2    'delete one entry'
Global Const E1432_PROG_ADD = 3       'add one entry

'  Bit position defines in registers

'  E1432_STATUS_REG
Global Const E1432_STATUS_CMD_READY = &H1&
Global Const E1432_STATUS_Q_RESP_READY = &H2&
Global Const E1432_STATUS_PASSED = &H4&
Global Const E1432_STATUS_READY = &H8&
Global Const E1432_STATUS_HW_OK = &H10&
Global Const E1432_STATUS_UNUSED1 = &H20&
Global Const E1432_STATUS_ERR_N = &H40&
Global Const E1432_STATUS_DONE = &H80&
Global Const E1432_STATUS_LOADED = &H100&
Global Const E1432_STATUS_ST_DONE = &H200&
Global Const E1432_STATUS_DATA_READY = &H400&
Global Const E1432_STATUS_BLOCK_READY = &H800&
Global Const E1432_STATUS_UNUSED2 = &H1000&
Global Const E1432_STATUS_UNUSED3 = &H2000&
Global Const E1432_STATUS_MODID_N = &H4000&
Global Const E1432_STATUS_A24_ACTIVE = &H8000&

'  E1432_CONTROL_REG
Global Const E1432_CONTROL_RESET_ON = &H1
Global Const E1432_CONTROL_RESET_OFF = &H0
Global Const E1432_CONTROL_SYSFAIL_INHIBIT_ON = &H2
Global Const E1432_CONTROL_SYSFAIL_INHIBIT_OFF = &H0
Global Const E1432_CONTROL_A24_ENABLE = &H8000&

'  E1432_MEAS_STATE_REG

'  These must be in order, and must start with zero.  Also, DUMMY must follow
'   CONVERT_WAIT2, and the ERROR states must be larger than the normal
'   states.
Global Const E1432_MEAS_STATE_MASK = &H1F
Global Const E1432_MEAS_STATE_TESTED = &H0
Global Const E1432_MEAS_STATE_BOOTING = &H1
Global Const E1432_MEAS_STATE_BOOTING_WAIT1 = &H2
Global Const E1432_MEAS_STATE_BOOTING_WAIT2 = &H3
Global Const E1432_MEAS_STATE_BOOTED = &H4
Global Const E1432_MEAS_STATE_SYNC = &H5
Global Const E1432_MEAS_STATE_SYNC_WAIT1 = &H6
Global Const E1432_MEAS_STATE_PRE_ARM = &H7
Global Const E1432_MEAS_STATE_PRE_ARM_WAIT2 = &H8
Global Const E1432_MEAS_STATE_IDLE = &H9
Global Const E1432_MEAS_STATE_ARM = &HA
Global Const E1432_MEAS_STATE_ARM_WAIT1 = &HB
Global Const E1432_MEAS_STATE_ARM_WAIT2 = &HC
Global Const E1432_MEAS_STATE_TRIGGER = &HD
Global Const E1432_MEAS_STATE_CONVERT = &HE
Global Const E1432_MEAS_STATE_CONVERT_WAIT1 = &HF
Global Const E1432_MEAS_STATE_CONVERT_WAIT2 = &H10
Global Const E1432_MEAS_STATE_DUMMY = &H11
Global Const E1432_MEAS_STATE_ERROR = &H12
Global Const E1432_MEAS_STATE_ERROR_WAIT1 = &H13
Global Const E1432_MEAS_STATE_ERROR_WAIT2 = &H14
Global Const E1432_MEAS_STATE_MAX = &H15

'  E1432_IRQ_CONFIG_REG
Global Const E1432_IRQ_PRIORITY = &H7
Global Const E1432_IRQ_PRIORITY_NONE = &H0
Global Const E1432_IRQ_PRIORITY_MIN = &H1
Global Const E1432_IRQ_PRIORITY_MAX = &H7
Global Const E1432_IRQ_PRIORITY_DEF = &H0

'  E1432_IRQ_CONFIG_0_REG and E1432_IRQ_STATUS_REG
Global Const E1432_IRQ_STSTUS_LADDR_MASK = &HFF&
Global Const E1432_IRQ_MASK = &HFF00&
Global Const E1432_IRQ_SHIFT = 8
Global Const E1432_IRQ_MEAS_WARNING = &H100&
Global Const E1432_IRQ_BLOCK_READY = &H200&
Global Const E1432_IRQ_MEAS_STATE_CHANGE = &H400&
Global Const E1432_IRQ_TRIGGER = &H800&
Global Const E1432_IRQ_OVERLOAD_CHANGE = &H1000&
Global Const E1432_IRQ_MEAS_ERROR = &H2000&
Global Const E1432_IRQ_TACHS_AVAIL = &H4000&
Global Const E1432_IRQ_SRC_STATUS = &H8000&
Global Const E1432_STATUS2_TACH_OVERFLOW = &H1&



'  E1432_FLAG_CREG
Global Const E1432_FLAG_OVERLOAD_COM = &H1
Global Const E1432_FLAG_OVERLOAD_ADC = &H2
Global Const E1432_FLAG_OVERLOAD_DIFF = &H4


Global Const E1432_SERIAL_LENGTH = 20

' structures
Type e1432_hwconfig
'structure returned by e1432_get_hwconfig()
    man_id As Integer       'VXI manufacturer ID number
    model_code As Integer   'VXI Model code
    hw_rev As Long          'hardware revision. 1 + clock/trig xilinx
    bootrom_rev As Long     'Flash boot prog rev.  YYYYMMDD
    fw_rev As Long          'firmware revision.  YYYYMMDD
    sca_id(1 To E1432_SCAS) As Integer
    sca_rev(1 To E1432_SCAS) As Long    '0 to n
    bob_id(1 To E1432_SCAS) As Integer  'Break-out Box type
    total_chans As Integer
    input_chans As Integer
    source_chans As Integer
    tach_chans As Integer
    oct_present As Integer 'octave option (1D1) installed
    lbus_present As Integer
    dram_size As Long      'number of 32-bit words
    a24_used As Long       'bytes of VXI A24 memory used
    serial As String * E1432_SERIAL_LENGTH  'serial number
End Type

Type E1432_INSTALL_FROM_MEM
    nByte  As Long
    datPointer  As Long
End Type

Type e1432_trailer
    trig_corr As Single
    zoom_corr As Single
    rpm1 As Single
    rpm2 As Single
    gap  As Long
    info  As Long
    peak As Single
    rms  As Single
End Type

'  Function prototypes


'  Module setups
Declare Function e1432_get_anti_alias_digital Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_anti_alias_digital Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_weighting Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_weighting Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_append_status Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_append_status Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_auto_arm Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_auto_arm Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_auto_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_auto_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_avg_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_avg_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_avg_number Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_avg_number Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_avg_update Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_avg_update Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_avg_weight Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_avg_weight Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_blocksize Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_blocksize_current_max Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_blocksize_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_blocksize Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_center_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_center_freq_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_center_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_clock_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_clock_freq_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_clock_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_clock_master Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_clock_master Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_clock_source Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_clock_source Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_data_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_data_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_data_port Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_data_port Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_data_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_data_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_decimation_output Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_decimation_output Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_decimation_oversample Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_decimation_oversample Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_delta_order Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_delta_order Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_enable Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal typ%, Pointer%) As Integer
Declare Function e1432_set_enable Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal typ%, ByVal V%) As Integer

Declare Function e1432_get_fifo_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_fifo_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer

Declare Function e1432_get_max_order Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_max_order Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_meas_time_length Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_meas_time_length Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_filter_settling_time Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_filter_settling_time_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_filter_settling_time Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_internal_debug Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_internal_debug_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_internal_debug Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_interrupt_mask Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_interrupt_mask Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_interrupt_priority Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_get_interrupt_priority_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_interrupt_priority Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_lbus_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_lbus_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_lbus_reset Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_reset_lbus Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_multi_sync Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_multi_sync Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer


Declare Function e1432_get_overlap Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_overlap_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_overlap Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer

Declare Function e1432_get_pre_arm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_pre_arm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_pre_arm_rpm Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_pre_arm_rpm Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_ramp Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ramp Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer


Declare Function e1432_get_rms_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_rms_span_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_rms_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_sample_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_sample_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_span_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer


Declare Function e1432_get_trigger_delay Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_trigger_delay_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_trigger_delay Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_trigger_ext Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_trigger_ext Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_trigger_master Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_trigger_master Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_triggers_per_arm Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_triggers_per_arm Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_ttltrg_clock Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ttltrg_clock Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_ttltrg_gclock Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ttltrg_gclock Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_ttltrg_satrg Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ttltrg_satrg Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_ttltrg_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ttltrg_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_window Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_window Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_zoom Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_zoom Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer


'  Channel setups
Declare Function e1432_get_active Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_active Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_amp_scale Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_amp_scale_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_amp_scale Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_anti_alias_analog Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_anti_alias_analog Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_autozero_offset Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_autozero_offset Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_coupling Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_coupling Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_coupling_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_coupling_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_filter_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_filter_freq_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_filter_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_input_high Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_input_high Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_input_low Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_input_low Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_input_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_input_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_input_offset Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_input_offset Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_next_arm_rpm Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer

Declare Function e1432_get_ramp_rate Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_ramp_rate_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_ramp_rate Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_range Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_range_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_range Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_range_charge Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_range_charge_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_range_charge Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_range_mike Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_range_mike_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_range_mike Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_sine_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_sine_freq_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_sine_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_sine_phase Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_sine_phase_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_sine_phase Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_source_blocksize Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_source_blocksize Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal s&) As Integer
Declare Function e1432_get_source_center_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_source_center_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
                                             
Declare Function e1432_get_source_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_source_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_source_output Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_source_output Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_source_seed Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_source_seed Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_source_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_source_span Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_srcbuffer_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_srcbuffer_size Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal s&) As Integer
Declare Function e1432_get_srcbuffer_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_srcbuffer_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_srcbuffer_init Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_srcbuffer_init Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_srcparm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_set_srcparm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal s&) As Integer

Declare Function e1432_write_srcbuffer_data Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&, ByVal NumWords&, ByVal Mode%) As Integer


Declare Function e1432_get_source_cola Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_source_cola Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_source_sum Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_source_sum Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_tach_clock_freq Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_tach_decimate Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_tach_decimate_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_tach_decimate Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V&) As Integer
Declare Function e1432_get_tach_delay Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_tach_holdoff Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_get_tach_holdoff_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_tach_holdoff Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_tach_max_time Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer!) As Integer
Declare Function e1432_set_tach_max_time Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_tach_ppr Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_tach_ppr_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_tach_ppr Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_trigger_channel Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_trigger_channel Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_trigger_level Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal which%, lev!) As Integer
Declare Function e1432_get_trigger_level_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal which%, mn!, mx!, df!, sp!) As Integer
Declare Function e1432_set_trigger_level Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal which%, ByVal lev!) As Integer
Declare Function e1432_get_trigger_slope Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_trigger_slope Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_trigger_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_trigger_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer


Declare Function e1432_get_arm_channel Lib "E1432.DLL" (ByVal hw&, ByVal id%, V%) As Integer
Declare Function e1432_set_arm_channel Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_arm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, V%) As Integer
Declare Function e1432_set_arm_mode Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_arm_time_interval Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_arm_time_interval_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_arm_time_interval Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_auto_group_meas Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_auto_group_meas Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

Declare Function e1432_get_rpm_high Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_rpm_high_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_rpm_high Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_rpm_interval Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_rpm_interval_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_rpm_interval Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_rpm_low Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_rpm_low_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_rpm_low Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_rpm_smoothing Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_rpm_smoothing_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_rpm_smoothing Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer

Declare Function e1432_get_current_rpm Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer

Declare Function e1432_get_data_rpm Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer

Declare Function e1432_get_duty_cycle Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_duty_cycle_limits Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!, V!, V!, V!) As Integer
Declare Function e1432_set_duty_cycle Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer




'  Short cuts
Declare Function e1432_preset Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_set_analog_input Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal Mode%, ByVal source%, ByVal state%, ByVal coupling%, ByVal range!) As Integer
Declare Function e1432_set_data_format Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal blocksize&, ByVal siz%, ByVal Mode%, ByVal appen%) As Integer
Declare Function e1432_set_interrupt Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal priority%, ByVal mask%) As Integer
Declare Function e1432_set_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal chanState%, ByVal delay&, ByVal level0!, ByVal level1!, ByVal slope%, ByVal Mode%) As Integer
Declare Function e1432_get_ttltrg_lines Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_ttltrg_lines Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

'  Group setups
Declare Function e1432_assign_channel_numbers Lib "E1432.DLL" (ByVal modCount%, laddrList%, hw&) As Integer
Declare Function e1432_assign_channels Lib "E1432.DLL" (ByVal modCount%, laddrList%, hw&, ByVal present%) As Integer
Declare Function e1432_get_hwconfig Lib "E1432.DLL" (ByVal modCount%, laddrList%, config As e1432_hwconfig) As Integer
Declare Function e1432_install Lib "E1432.DLL" (ByVal modCount%, laddrList%, ByVal flags&, ByVal fileName As String) As Integer
Declare Function e1432_set_interface_addr Lib "E1432.DLL" (ByVal siclName As String) As Integer
Declare Function e1432_uninit_io_driver Lib "E1432.DLL" () As Integer
Declare Function e1432_zap Lib "E1432.DLL" (ByVal la%, ByVal prom%, ByVal siz&, buff As Any) As Integer
Declare Function e1432_read_flash Lib "E1432.DLL" (ByVal la%, ByVal prom%, ByVal siz&, buff As Any) As Integer

Declare Function e1432_create_channel_group Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_get_group_info Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal typ%, answer%, ByVal answerLen%) As Integer
Declare Function e1432_delete_channel_group Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_delete_all_chan_groups Lib "E1432.DLL" (ByVal hw&) As Integer

Declare Function e1432_init_io_driver Lib "E1432.DLL" () As Integer




'  Actions
Declare Function e1432_arm_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer
Declare Function e1432_auto_range Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V#) As Integer
Declare Function e1432_auto_zero Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_cached_parm_update Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_finish_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer

Declare Function e1432_init_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_init_measure_finish Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer
Declare Function e1432_init_measure_master_finish Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer
Declare Function e1432_init_measure_master_setup Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer
Declare Function e1432_init_measure_slave_finish Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_init_measure_slave_middle Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_init_measure_slave_setup Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer

Declare Function e1432_init_measure_to_booted Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer

Declare Function e1432_pre_arm_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal waitA%) As Integer
Declare Function e1432_read_i2c Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal addr%, V%) As Integer
Declare Function e1432_reenable_interrupt Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_send_trigger Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_send_tachs Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal tachID%, buf&, ByVal cnt&) As Integer
Declare Function e1432_get_samples_to_pre_arm Lib "E1432.DLL" (ByVal hw&, ByVal id%, V&) As Integer
Declare Function e1432_get_trigger_corr Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer

Declare Function e1432_trigger_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_reset Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_reset_measure Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_test_lbus Lib "E1432.DLL" (ByVal hw&, ByVal ch%, ByVal V2%) As Integer
Declare Function e1432_write_i2c Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal addr%, ByVal V%) As Integer

' diagnostics/selftest
Declare Function e1432_install_file Lib "E1432.DLL" (ByVal file As String, ByVal from_mem As Integer) As Integer
Declare Function e1432_selftest Lib "E1432.DLL" (ByVal mods%, las%, ByVal tests%, opts As String) As Integer
Declare Function i1432_selftest Lib "E1432.DLL" (ByVal la%, ByVal tests%, ByVal main%, mem%, scas As Integer) As Integer
Declare Function e1432_set_printf_window Lib "E1432.DLL" (ByVal hwndTextBox%) As Integer
Declare Function e1432_set_diag_print_level Lib "E1432.DLL" (ByVal print_level%) As Integer

'  Results
Declare Function e1432_check_overloads Lib "E1432.DLL" (ByVal hw&, ByVal id%, anyo%, common%, diff%, half%) As Integer
Declare Function e1432_read_rms_peak_data Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, rms!, peak!, ByVal POINTS&, actualCnt&, ByVal Hold!, ByVal decay!) As Integer
Declare Function e1432_read_raw_data Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, ByVal which%, buf As Any, ByVal siz&, t As e1432_trailer, actualCnt&) As Integer
Declare Function e1432_read_float32_data Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, ByVal which%, buf As Any, ByVal siz&, t As e1432_trailer, actualCnt&) As Integer
Declare Function e1432_read_float64_data Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, ByVal which%, buf As Any, ByVal siz&, t As e1432_trailer, actualCnt&) As Integer
Declare Function e1432_get_raw_tachs Lib "E1432.DLL" (ByVal hw&, ByVal id%, buf&, actualCount&) As Integer

'  General inquiry
Declare Function e1432_block_available Lib "E1432.DLL" (ByVal hw&, ByVal chanID%) As Integer
Declare Function e1432_get_decimation Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer&) As Integer
Declare Function e1432_get_meas_state Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_get_meas_warning Lib "E1432.DLL" (ByVal hw&, ByVal id%, warning%, ByVal siz&, ByVal cnt&) As Integer
Declare Function e1432_get_scale Lib "E1432.DLL" (ByVal hw&, ByVal id%, scalePtr#) As Integer

Declare Function e1432_get_src_arbstates Lib "E1432.DLL" (ByVal hw&, ByVal id%, V1&, V2&, V3&, V4&) As Integer
Declare Function e1432_check_src_arbrdy Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_check_src_shutdown Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_check_src_overload Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer
Declare Function e1432_check_src_overread Lib "E1432.DLL" (ByVal hw&, ByVal id%) As Integer


'  Debugging setup
Declare Sub e1432_debug_level Lib "E1432.DLL" (ByVal V%)
Declare Function e1432_print_errors Lib "E1432.DLL" (ByVal V%) As Integer
Declare Sub e1432_trace_level Lib "E1432.DLL" (ByVal V%)

'  Debugging
Declare Function e1432_display_state Lib "E1432.DLL" (ByVal hw&) As Integer
Declare Function e1432_fill_error_string Lib "E1432.DLL" (ByVal error_string As String, ByVal max_len%, actual_len%) As Integer
Declare Function e1432_read_register Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, ByVal REG&, dat%) As Integer
Declare Function e1432_read32_register Lib "E1432.DLL" (ByVal hw&, ByVal chanID%, ByVal REG&, dat&) As Integer
Declare Function e1432_write_register Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal REG&, ByVal dat%) As Integer
Declare Function e1432_write32_register Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal REG&, ByVal dat&) As Integer
Declare Function e1432_read_fw_marker Lib "E1432.DLL" (ByVal la%, marker&) As Integer

'  Additional Debugging, only for the windows version (no hwblkio)
Declare Function e1432_write_dsp_mem Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal busBY%, ByVal dspAddr&, ByVal dspData&) As Integer

Declare Function e1432_read_dsp_mem Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal busBY%, ByVal dspAddr&, dspData&) As Integer

Declare Function e1432_write_clarinet_dsp Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal memSpace%, ByVal dspAddr&, ByVal dspData&) As Integer
Declare Function e1432_set_clarinet_dc Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal preAttenDC!, ByVal postAttenDC!) As Integer
Declare Function e1432_get_clarinet_dc Lib "E1432.DLL" (ByVal hw&, ByVal id%, preAttenDC!, postAttenDC!) As Integer

Declare Function e1432_zap_src_boot Lib "E1432.DLL" (ByVal la%, ByVal prom%, ByVal doParms%, ByVal fileDir As String) As Integer
Declare Function e1432_set_cal_date_41 Lib "E1432.DLL" (bdParms&) As Integer
Declare Function e1432_zap01_boot Lib "E1432.DLL" (ByVal la%, ByVal fileName As String) As Integer
Declare Function e1432_zap01_subst_cal Lib "E1432.DLL" (ByVal la%, ByVal serial$, ByVal boardNum$, ByVal dateCode&, calValues!) As Integer
Declare Function e1432_zap01_read_subst_cal Lib "E1432.DLL" (ByVal la%, serial As Any, boardNum As Any, dateCode&, calValues!, calDate&) As Integer

Declare Function e1432_zap01_sca_cal Lib "E1432.DLL" (ByVal la%, ByVal sca%, ByVal boardNum$, ByVal dateCode&, ByVal chans%, ByVal ranges%, ByVal entries%, calValues!) As Integer

Declare Function e1432_zap01_sonata_cal Lib "E1432.DLL" (ByVal la%, ByVal sca%, ByVal boardNum$, ByVal dateCode&, calValues!) As Integer
Declare Function e1432_zap01_extra_sonata_cal Lib "E1432.DLL" (ByVal la%, ByVal sca%, ByVal valid%, calValues!) As Integer

Declare Function e1432_zap01_read_sonata_cal Lib "E1432.DLL" (ByVal la%, ByVal sca%, boardNum As Any, dateCode&, calDate&) As Integer

Declare Function e1432_zap_parm2_opts Lib "E1432.DLL" (ByVal la%, ByVal oper%, ByVal opt$) As Integer
'obsolete zap functions
'Declare Function e1432_zap01_cal Lib "E1432.DLL" (ByVal la%, ByVal serial As String, calValues!) As Integer
'Declare Function e1432_zap01_read_cal Lib "E1432.DLL" (ByVal la%, rev_length&, CalDate&, calValues!) As Integer

' substrate cal subs

Declare Function e1432_set_calin Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_calin Lib "E1432.DLL" (ByVal hw&, ByVal id%, V%) As Integer
Declare Function e1432_set_sumbus Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_sumbus Lib "E1432.DLL" (ByVal hw&, ByVal id%, V%) As Integer

Declare Function e1432_set_cal_dac Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer
Declare Function e1432_get_cal_dac Lib "E1432.DLL" (ByVal hw&, ByVal id%, V%) As Integer
Declare Function e1432_set_cal_voltage Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_cal_voltage Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
'un-corrected cal voltage functions.
Declare Function e1432_set_cal_voltage_uc Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V!) As Integer
Declare Function e1432_get_cal_voltage_uc Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer

Declare Function e1432_get_calc_data Lib "E1432.DLL" (ByVal hw&, ByVal id%, Pointer%) As Integer
Declare Function e1432_set_calc_data Lib "E1432.DLL" (ByVal hw&, ByVal id%, ByVal V%) As Integer

' Input cal subs

Declare Function e1432_get_cal_gain Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_cal_gain2 Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_cal_offset Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_cal_offset2 Lib "E1432.DLL" (ByVal hw&, ByVal id%, V!) As Integer
Declare Function e1432_get_cal_failures Lib "E1432.DLL" (ByVal hw&, ByVal id%, V&) As Integer


' e1432_set_cal_dac scale factors
Global Const E1432_CALDAC2V_HI = (15# / 2048)
Global Const E1432_CALDAC2V_LO = (0.4838 / 2048)

Function vb_e1432_zap01_read_sonata_cal(ByVal la%, ByVal sca%, boardNum$, dateCode&, calDate&) As Integer
    'converts returned strings for VB
    Dim er As Integer, p As Integer
    Dim boardNumStr As String * 22
    
    boardNum = ""
    er = e1432_zap01_read_sonata_cal(la%, sca%, ByVal boardNumStr, dateCode&, calDate&)
    p = InStr(boardNumStr, Chr$(0))
    If p > 0 Then boardNum = Left$(boardNumStr, p - 1)
    vb_e1432_zap01_read_sonata_cal = er
End Function

Function vb_e1432_zap01_read_subst_cal(ByVal la%, serial$, boardNum$, dateCode&, calValues!, calDate&) As Integer
    'converts returned strings for VB
    Dim er As Integer, p As Integer
    Dim serialStr As String * 22
    Dim boardNumStr As String * 22
    
    serial = ""
    boardNum = ""
    er = e1432_zap01_read_subst_cal(la%, ByVal serialStr, ByVal boardNumStr, dateCode&, calValues!, calDate&)
    p = InStr(serialStr, Chr$(0))
    If p > 0 Then serial = Left$(serialStr, p - 1)
    p = InStr(boardNumStr, Chr$(0))
    If p > 0 Then boardNum = Left$(boardNumStr, p - 1)
    vb_e1432_zap01_read_subst_cal = er
End Function

